<?php
require_once __DIR__ . '/../models/Transaction.php';

class DashboardController
{
    private $txn;

    public function __construct($pdo)
    {
        $this->txn = new Transaction($pdo);
    }

    public function index()
    {
        $totals = $this->txn->summary();
        $today = $this->txn->today();
        $month = $this->txn->month();
        $year = $this->txn->year();

        // Chart data (last 7 days)
        $chart = $this->txn->last7Days();
        $view = 'dashboard';
        require __DIR__ . '/../views/layout.php';
    }
}
