<?php
require_once __DIR__ . '/../models/Transaction.php';

class ReportsController
{
    private Transaction $txn;

    public function __construct(PDO $pdo)
    {
        $this->txn = new Transaction($pdo);
    }

    public function index()
    {
        $type = $_GET['type'] ?? 'daily';

        $data = [];
        $summary = ['income' => 0, 'expense' => 0];

        if ($_SERVER['REQUEST_METHOD'] === 'POST') {

            if ($type === 'daily') {
                $data = $this->txn->reportByDate($_POST['date']);
            }

            if ($type === 'monthly') {
                $data = $this->txn->reportByMonth($_POST['month']);
            }

            if ($type === 'yearly') {
                $data = $this->txn->reportByYear($_POST['year']);
            }

            if ($type === 'custom') {
                $data = $this->txn->reportByRange($_POST['start'], $_POST['end']);
            }

            foreach ($data as $t) {
                if ($t['type'] === 'income') {
                    $summary['income'] += $t['amount'];
                } else {
                    $summary['expense'] += $t['amount'];
                }
            }
        }

        // ✅ MUST SET VIEW
        $view = 'reports';
        require __DIR__ . '/../views/layout.php';
    }
}
