<?php

require_once __DIR__ . '/../models/Transaction.php'; // ✅ REQUIRED

class TransactionController {
    private $txn;

    public function __construct($pdo) {
        $this->txn = new Transaction($pdo);
    }

    public function index() {
        $list = $this->txn->allWithBalance();
        $view = 'transactions';
        require __DIR__ . '/../views/layout.php';
    }

    public function add() {
        if ($_POST) {
            $this->txn->add($_POST);
            header("Location: ?page=transactions");
            exit;
        }

        $view = 'add';
        require __DIR__ . '/../views/layout.php';
    }
}
