<form method="post" class="card analytics-form mb-3">

    <div class="analytics-header mb-3">
        <h6>Date Range Analysis</h6>
        <small>Analyze income & expenses for a specific period</small>
    </div>

    <div class="row g-2">
        <div class="col-6">
            <label>Start Date</label>
            <input type="date" name="start" class="form-control" required>
        </div>

        <div class="col-6">
            <label>End Date</label>
            <input type="date" name="end" class="form-control" required>
        </div>
    </div>

    <button class="btn btn-secondary w-100 mt-3 analyze-btn">
        <i class="bi bi-bar-chart"></i> Analyze Period
    </button>
</form>

<?php if ($result):
$days = max(1, (strtotime($_POST['end']) - strtotime($_POST['start'])) / 86400);
$net = $result['income'] - $result['expense'];
?>

<!-- RESULTS -->
<div class="row g-3">

    <div class="col-md-4 col-6">
        <div class="card insight-card income">
            <span>Total Income</span>
            <h4>₹<?= number_format($result['income'],2) ?></h4>
        </div>
    </div>

    <div class="col-md-4 col-6">
        <div class="card insight-card expense">
            <span>Total Expense</span>
            <h4>₹<?= number_format($result['expense'],2) ?></h4>
        </div>
    </div>

    <div class="col-md-4 col-12">
        <div class="card insight-card balance">
            <span>Net Balance</span>
            <h4>₹<?= number_format($net,2) ?></h4>
        </div>
    </div>

    <div class="col-md-6 col-6">
        <div class="card insight-card neutral">
            <span>Avg Income / Day</span>
            <h5>₹<?= number_format($result['income'] / $days, 2) ?></h5>
        </div>
    </div>

    <div class="col-md-6 col-6">
        <div class="card insight-card neutral">
            <span>Avg Expense / Day</span>
            <h5>₹<?= number_format($result['expense'] / $days, 2) ?></h5>
        </div>
    </div>

</div>
<?php endif; ?>
