<?php
$balance = $totals['income'] - $totals['expense'];

$labels = $income = $expense = [];
if (!empty($chart)) {
    foreach ($chart as $c) {
        $labels[] = $c['transaction_date'];
        $income[] = (float) $c['income'];
        $expense[] = (float) $c['expense'];
    }
}
?>

<!-- ================= KPI ROW ================= -->
<div class="row g-3">

    <!-- BALANCE -->
    <div class="col-md-4 col-12">
        <div class="card stat-card stat-balance">
            <div class="stat-icon bg-success-soft">
                <i class="bi bi-wallet2"></i>
            </div>
            <div class="stat-info">
                <h6>Current Balance</h6>
                <h3 class="text-success">₹<?= number_format($balance, 2) ?></h3>
            </div>
        </div>
    </div>

    <!-- INCOME -->
    <div class="col-md-4 col-6">
        <div class="card stat-card">
            <div class="stat-icon bg-income-soft">
                <i class="bi bi-arrow-down-left"></i>
            </div>
            <div class="stat-info">
                <h6>Total Income</h6>
                <h4 class="text-success">₹<?= number_format($totals['income'], 2) ?></h4>
            </div>
        </div>
    </div>

    <!-- EXPENSE -->
    <div class="col-md-4 col-6">
        <div class="card stat-card">
            <div class="stat-icon bg-expense-soft">
                <i class="bi bi-arrow-up-right"></i>
            </div>
            <div class="stat-info">
                <h6>Total Expense</h6>
                <h4 class="text-danger">₹<?= number_format($totals['expense'], 2) ?></h4>
            </div>
        </div>
    </div>

</div>

<!-- ================= PERIOD SUMMARY ================= -->
<div class="row g-3 mt-1">

    <div class="col-md-4 col-6">
        <div class="card mini-stat">
            <span>Today</span>
            <b class="text-success">+₹<?= $today['income'] ?></b>
            <small class="text-danger">−₹<?= $today['expense'] ?></small>
        </div>
    </div>

    <div class="col-md-4 col-6">
        <div class="card mini-stat">
            <span>This Month</span>
            <b class="text-success">+₹<?= $month['income'] ?></b>
            <small class="text-danger">−₹<?= $month['expense'] ?></small>
        </div>
    </div>

    <div class="col-md-4 col-12">
        <div class="card mini-stat">
            <span>This Year</span>
            <b class="text-success">+₹<?= $year['income'] ?></b>
            <small class="text-danger">−₹<?= $year['expense'] ?></small>
        </div>
    </div>

</div>

<!-- ================= CHARTS ================= -->
<div class="row g-3 mt-3">

    <div class="col-md-6">
        <div class="card chart-card">
            <div class="chart-header">
                <h6>Income vs Expense</h6>
                <small>Last 7 days</small>
            </div>
            <div class="chart-box">
                <canvas id="barChart"></canvas>
            </div>
        </div>
    </div>

    <div class="col-md-6">
        <div class="card chart-card">
            <div class="chart-header">
                <h6>Cash Flow Trend</h6>
                <small>Daily movement</small>
            </div>
            <div class="chart-box">
                <canvas id="lineChart"></canvas>
            </div>
        </div>
    </div>

</div>

<script>
    document.addEventListener("DOMContentLoaded", function () {

        const labels = <?= json_encode($labels) ?>;
        const income = <?= json_encode($income) ?>;
        const expense = <?= json_encode($expense) ?>;

        if (labels.length === 0) {
            console.warn("No chart data available");
            return;
        }

        new Chart(document.getElementById('barChart'), {
            type: 'bar',
            data: {
                labels: labels,
                datasets: [
                    {
                        label: 'Income',
                        data: income,
                        backgroundColor: '#16a34a',
                        borderRadius: 6
                    },
                    {
                        label: 'Expense',
                        data: expense,
                        backgroundColor: '#dc2626',
                        borderRadius: 6
                    }
                ]
            },
            options: {
                responsive: true,
                plugins: {
                    legend: { position: 'top' }
                },
                scales: {
                    y: { beginAtZero: true }
                }
            }
        });

        new Chart(document.getElementById('lineChart'), {
            type: 'line',
            data: {
                labels: labels,
                datasets: [
                    {
                        label: 'Income',
                        data: income,
                        borderColor: '#16a34a',
                        backgroundColor: 'rgba(22,163,74,0.15)',
                        tension: 0.4,
                        fill: true
                    },
                    {
                        label: 'Expense',
                        data: expense,
                        borderColor: '#dc2626',
                        backgroundColor: 'rgba(220,38,38,0.12)',
                        tension: 0.4,
                        fill: true
                    }
                ]
            },
            options: {
                responsive: true,
                plugins: {
                    legend: { position: 'top' }
                }
            }
        });


    });
</script>