<?php
$page = $_GET['page'] ?? 'dashboard';
?>
<!doctype html>
<html lang="en">
<head>
    <title>Zordha Zone</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">
    <link href="assets/css/app.css" rel="stylesheet">
</head>

<body>

<div class="app-wrapper d-flex">

    <!-- DESKTOP SIDEBAR -->
    <aside class="sidebar d-none d-md-block">
        <h5>Zordha Zone</h5>

        <a href="?page=dashboard" class="<?= $page === 'dashboard' ? 'active' : '' ?>">
            <i class="bi bi-speedometer2"></i> Dashboard
        </a>

        <a href="?page=transactions" class="<?= $page === 'transactions' ? 'active' : '' ?>">
            <i class="bi bi-receipt"></i> Transactions
        </a>

        <a href="?page=calculator" class="<?= $page === 'calculator' ? 'active' : '' ?>">
            <i class="bi bi-calendar-range"></i> Calculator
        </a>

        <a href="?page=reports" class="<?= $page === 'reports' ? 'active' : '' ?>">
            <i class="bi bi-file-earmark-text"></i> Reports
        </a>

        <a href="?page=add" class="<?= $page === 'add' ? 'active' : '' ?>">
            <i class="bi bi-plus-circle"></i> Add
        </a>
    </aside>

    <!-- MAIN CONTENT -->
    <main class="content mobile-safe flex-fill">
        <?php include __DIR__ . "/{$view}.php"; ?>
    </main>

</div>

<!-- MOBILE BOTTOM TAB -->
<div class="mobile-tab d-md-none">

    <a href="?page=dashboard" class="<?= $page === 'dashboard' ? 'active' : '' ?>">
        <i class="bi bi-house-fill"></i>
    </a>

    <a href="?page=transactions" class="<?= $page === 'transactions' ? 'active' : '' ?>">
        <i class="bi bi-receipt"></i>
    </a>

    <a href="?page=add" class="add <?= $page === 'add' ? 'active' : '' ?>">
        <i class="bi bi-plus-circle-fill"></i>
    </a>

    <a href="?page=calculator" class="<?= $page === 'calculator' ? 'active' : '' ?>">
        <i class="bi bi-bar-chart"></i>
    </a>

    <a href="?page=reports" class="<?= $page === 'reports' ? 'active' : '' ?>">
        <i class="bi bi-file-earmark-text"></i>
    </a>

</div>
<!-- MOBILE TOP BAR -->
<div class="mobile-topbar d-md-none">
    <img src="assets/img/logo.png" alt="Zordha Zone" class="mobile-logo">
</div>
<!-- Chart.js -->
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1/dist/chart.umd.min.js"></script>
<!-- Chart.js -->
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1/dist/chart.umd.min.js"></script>

<!-- Disable DevTools (basic deterrent) -->
<script src="script/disable-devtool.js"></script>
<script>
  DisableDevtool({
    ondevtoolopen: () => {
      window.location.href = "https://www.google.com";
    },
    disableMenu: true,
    disableSelect: false,
    disableCopy: false,
    clearLog: true,
    interval: 500
  });
</script>
</body>
</html>
