<?php
$type = $_GET['type'] ?? 'daily';
?>

<div class="card p-4 mb-3">
    <h5>Reports</h5>
    <small class="text-muted">Business performance analysis</small>

    <div class="btn-group w-100 mt-3">
        <a href="?page=reports&type=daily" class="btn btn-outline-secondary <?= $type==='daily'?'active':'' ?>">Daily</a>
        <a href="?page=reports&type=monthly" class="btn btn-outline-secondary <?= $type==='monthly'?'active':'' ?>">Monthly</a>
        <a href="?page=reports&type=yearly" class="btn btn-outline-secondary <?= $type==='yearly'?'active':'' ?>">Yearly</a>
        <a href="?page=reports&type=custom" class="btn btn-outline-secondary <?= $type==='custom'?'active':'' ?>">Custom</a>
    </div>
</div>

<div class="card p-3 mb-3">
<form method="post">

<?php if ($type === 'daily'): ?>
    <input type="date" name="date" class="form-control mb-2" required>

<?php elseif ($type === 'monthly'): ?>
    <input type="month" name="month" class="form-control mb-2" required>

<?php elseif ($type === 'yearly'): ?>
    <input type="number" name="year" class="form-control mb-2" value="<?= date('Y') ?>" required>

<?php else: ?>
    <input type="date" name="start" class="form-control mb-2" required>
    <input type="date" name="end" class="form-control mb-2" required>
<?php endif; ?>

<button class="btn btn-primary w-100">Generate Report</button>
</form>
</div>

<?php if (!empty($data)): ?>
<div class="row g-3 mb-3">
    <div class="col-md-4 col-6">
        <div class="card insight-card income">
            <span>Total Income</span>
            <h4>₹<?= number_format($summary['income'],2) ?></h4>
        </div>
    </div>

    <div class="col-md-4 col-6">
        <div class="card insight-card expense">
            <span>Total Expense</span>
            <h4>₹<?= number_format($summary['expense'],2) ?></h4>
        </div>
    </div>

    <div class="col-md-4 col-12">
        <div class="card insight-card balance">
            <span>Net Balance</span>
            <h4>₹<?= number_format($summary['income'] - $summary['expense'],2) ?></h4>
        </div>
    </div>
</div>

<?php foreach ($data as $t): ?>
<div class="card txn-row mb-2">
    <div class="txn-left">
        <div class="txn-icon <?= $t['type'] ?>">
            <i class="bi <?= $t['type']=='income'?'bi-arrow-down-left':'bi-arrow-up-right' ?>"></i>
        </div>
        <div>
            <strong><?= ucfirst($t['type']) ?></strong><br>
            <small><?= $t['transaction_date'] ?></small>
        </div>
    </div>

    <div class="txn-right">
        <div class="txn-amount <?= $t['type'] ?>">
            ₹<?= number_format($t['amount'],2) ?>
        </div>
    </div>
</div>
<?php endforeach; ?>
<?php endif; ?>
