<div class="card p-4 mb-3">
    <h5>Daily Report</h5>
    <small class="text-muted">Select a date to view transactions</small>

    <form method="post" class="row g-2 mt-3">
        <div class="col-md-4 col-8">
            <input type="date" name="start" required>
            <input type="date" name="end" required>
        </div>
        <div class="col-md-2 col-4">
            <button class="btn btn-primary w-100">View</button>
        </div>
    </form>
</div>

<?php if (!empty($data)): ?>
    <div class="row g-3 mb-3">
        <div class="col-md-4 col-6">
            <div class="card insight-card income">
                <span>Total Income</span>
                <h4>₹<?= number_format($summary['income'], 2) ?></h4>
            </div>
        </div>

        <div class="col-md-4 col-6">
            <div class="card insight-card expense">
                <span>Total Expense</span>
                <h4>₹<?= number_format($summary['expense'], 2) ?></h4>
            </div>
        </div>

        <div class="col-md-4 col-12">
            <div class="card insight-card balance">
                <span>Net Balance</span>
                <h4>₹<?= number_format($summary['income'] - $summary['expense'], 2) ?></h4>
            </div>
        </div>
    </div>

    <?php foreach ($data as $t): ?>
        <div class="card txn-row mb-2">
            <div class="txn-left">
                <div class="txn-icon <?= $t['type'] ?>">
                    <i class="bi <?= $t['type'] == 'income' ? 'bi-arrow-down-left' : 'bi-arrow-up-right' ?>"></i>
                </div>
                <div>
                    <strong><?= ucfirst($t['type']) ?></strong><br>
                    <small><?= $t['transaction_date'] ?></small>
                </div>
            </div>
            <div class="txn-right">
                <div class="txn-amount <?= $t['type'] ?>">
                    ₹<?= number_format($t['amount'], 2) ?>
                </div>
            </div>
        </div>
    <?php endforeach; ?>
<?php endif; ?>