<?php foreach ($list as $t): ?>
<div class="card txn-row mb-3">

    <!-- LEFT -->
    <div class="txn-left">

        <!-- ARROW ICON -->
        <div class="txn-icon <?= $t['type'] ?>">
            <i class="bi <?= $t['type'] === 'income'
                ? 'bi-arrow-down-left'
                : 'bi-arrow-up-right' ?>"></i>
        </div>

        <!-- INFO -->
        <div class="txn-info">
            <div class="txn-type">
                <?= ucfirst($t['type']) ?>
            </div>

            <div class="txn-date">
                <?= date('d M Y', strtotime($t['transaction_date'])) ?>
            </div>

            <?php if (!empty($t['category'])): ?>
                <div class="txn-category">
                    <?= htmlspecialchars($t['category']) ?>
                </div>
            <?php endif; ?>
        </div>

    </div>

    <!-- RIGHT -->
    <div class="txn-right">
        <div class="txn-amount <?= $t['type'] ?>">
            <?= $t['type'] === 'income' ? '+' : '−' ?>
            ₹<?= number_format($t['amount'], 2) ?>
        </div>

        <div class="txn-balance">
            Balance ₹<?= number_format($t['running_balance'], 2) ?>
        </div>
    </div>

</div>
<?php endforeach; ?>
